#include <bits/stdc++.h>
using namespace std;

struct TrieNode {
    unordered_map<char, TrieNode*> children;
    vector<long long> ends;
};

void insert(TrieNode* root, const string& s, long long original) {
    TrieNode* node = root;
    for (char ch : s) {
        if (!node->children.count(ch))
            node->children[ch] = new TrieNode();
        node = node->children[ch];
    }
    node->ends.push_back(original);
}

void dfs(TrieNode* node, vector<vector<long long>>& groups) {
    if (!node->ends.empty())
        groups.push_back(node->ends);
    for (auto& [_, child] : node->children)
        dfs(child, groups);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    TrieNode* root = new TrieNode();

    for (int i = 0; i < n; ++i) {
        cin >> a[i];
        insert(root, to_string(a[i]), a[i]);
    }

    vector<vector<long long>> groups;
    dfs(root, groups);

    cout << groups.size() << '\n';
    for (auto& group : groups) {
        cout << group.size() << '\n';
        for (long long x : group)
            cout << x << ' ';
        cout << '\n';
    }

    return 0;
}